/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.compat.artemislib;

import com.artemis.artemislib.util.attributes.ArtemisLibAttributes;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.math.MathHelper;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.util.TrinketsConfig;

public class SizeAttribute {
    private final String id = "xat.";
    private String name;
    protected final UUID uuid = UUID.fromString("02a31a03-4d5b-46ed-947b-322c4f004a75");
    protected final UUID uuidW = UUID.fromString("4ff77810-5a91-44ce-8e93-fc05a8d00def");
    private int operation;
    private EntityLivingBase entity;
    private double height;
    private double width;

    public SizeAttribute(EntityLivingBase entity, double height, double width, int operation) {
        this.entity = entity;
        this.name = "xat.artemislib.size.attribute";
        this.height = height;
        this.width = width;
        this.operation = operation;
    }

    public void addHeightModifier() {
        if (!TrinketsConfig.compat.artemislib) {
            this.removeHeightModifier();
            return;
        }
        IAttributeInstance AttributeInstance = this.entity.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_HEIGHT);
        if (AttributeInstance == null) {
            return;
        }
        double clampH = MathHelper.func_151237_a((double)this.height, (double)-0.75, (double)1024.0);
        if (AttributeInstance.func_111127_a(this.uuid) != null && AttributeInstance.func_111127_a(this.uuid).func_111164_d() != clampH) {
            this.removeHeightModifier();
        }
        if (AttributeInstance.func_111127_a(this.uuid) == null) {
            AttributeModifier modifier = new AttributeModifier(this.uuid, this.name + ".height", clampH, this.operation).func_111168_a(false);
            AttributeInstance.func_111121_a(modifier);
        }
    }

    public void addWidthModifier() {
        if (!TrinketsConfig.compat.artemislib) {
            this.removeWidthModifier();
            return;
        }
        IAttributeInstance AttributeInstance = this.entity.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_WIDTH);
        if (AttributeInstance == null) {
            return;
        }
        double clampW = MathHelper.func_151237_a((double)this.width, (double)-0.75, (double)1024.0);
        if (AttributeInstance.func_111127_a(this.uuidW) != null && AttributeInstance.func_111127_a(this.uuidW).func_111164_d() != clampW) {
            this.removeWidthModifier();
        }
        if (AttributeInstance.func_111127_a(this.uuidW) == null) {
            AttributeModifier modifier = new AttributeModifier(this.uuidW, this.name + ".width", clampW, this.operation).func_111168_a(false);
            AttributeInstance.func_111121_a(modifier);
        }
    }

    public void addModifiers() {
        if (Trinkets.ArtemisLib) {
            if (this.height != 0.0) {
                this.addHeightModifier();
            }
            if (this.width != 0.0) {
                this.addWidthModifier();
            }
        }
    }

    public void removeModifiers() {
        if (Trinkets.ArtemisLib) {
            this.removeHeightModifier();
            this.removeWidthModifier();
        }
    }

    public void removeHeightModifier() {
        IAttributeInstance AttributeInstance = this.entity.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_HEIGHT);
        if (AttributeInstance == null) {
            return;
        }
        if (AttributeInstance.func_111127_a(this.uuid) != null) {
            AttributeInstance.func_188479_b(this.uuid);
        }
    }

    public void removeWidthModifier() {
        IAttributeInstance AttributeInstanceW = this.entity.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_WIDTH);
        if (AttributeInstanceW == null) {
            return;
        }
        if (AttributeInstanceW.func_111127_a(this.uuidW) != null) {
            AttributeInstanceW.func_188479_b(this.uuidW);
        }
    }
}

